<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Timesheet extends Model 
{

    protected $table = 'timesheets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsTo('App\Models\Company\Project', 'project_id');
    }

    public function process()
    {
        return $this->belongsTo('App\Models\HR\Process', 'process_id');
    }

}